<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * @package direct-as-a-service
 * @subpackage controllers
 * @filesource
*//** */

require_once 'mailbox_controller.php';

/**
* API methods to manage a mailbox's messages.
*
* Inherits mailbox validation from the mailbox controller.  Mailbox name is a required field for all actions on this controller, with the exception of messages to send or save a messagage; these actions require the sender's email address to be provided.
*
* @author Elan Jaffee <jaffee_elan@bah.com>
*
* @package direct-as-a-service
* @subpackage controllers
*/
class Message_disclosure_controller extends Mailbox_controller{	
	
	/**
	* Everything that applies to all actions should go here.
	*/
	function __construct(){
		parent::__construct();
		//$this->load->helper(array('validate'));
	}
	public function log_disclosure_post(){
		$this->load->model('accountingdisclosuremodel');
		$this->load->model('facilitymodel');
		$required_fields = array('id','ssn','purpose','hash','first','last','org','title','patient_id','recipients');
			
		//set variables for each optional field
		foreach($required_fields as $field){
			$$field = element($field, $this->post(), null);
			if(is_null($$field)){
				$this->missing_required_fields[] = $field;
			}
		}
		$this->respond_with_error_if_fields_are_missing();
		$this->respond_with_error_if_user_is_unauthorized('send');
		$this->respond_with_error_if_mailbox_is_inactive();
		
		//check to make sure that id is valid
		if(!Message::formatted_like_an_id($id))
			$this->invalid_fields[] = 'id';
		if(!preg_match('/^[0-9]{9}$/',$ssn)){	//match ssn 9 numbers
			$this->invalid_fields[] = 'ssn';
		}
		if(empty($purpose)){
			$this->invalid_fields[] = 'purpose';
		}
		$recipients = json_decode($recipients);
		if(json_last_error() != JSON_ERROR_NONE){
			$this->invalid_fields[] = 'recipients';
		}
		$this->respond_with_error_if_fields_are_invalid();
		$message = Message::find_one($id);
		if(!Message::is_an_entity($message) || !$message->belongs_to_mailbox($this->mailbox)){
			$this->response('Message not found.', 422);
		}
		$facility = null;
		if($this->mailbox->facility_id){
			$query = $this->facilitymodel->get_facility($this->mailbox->facility_id);
			if($query){
				$query = $query->result();
				if(isset($query[0])){
					$facility = $query[0]->name;
				}
			}
		}
		$this->accountingdisclosuremodel->log_request($id, $this->mailbox->name, $facility, $hash, $patient_id,$first,$last,$org,$title,$recipients,$ssn,$purpose);
		$this->response("Logged disclosure",200);
	}
}	